
#BUGS - Xwhen initially going into the Load dialog with modality none
#       is the OS set right?  It looks like the initial display is
#       wrong, but it gets read right.  Need to fix this!  (this shows
#       up well with the List... button)
#     - note that with the modality removed from the load window, there
#       really should be three of them as opposed to the one...but the
#       variables are so darn intermingled that it works just fine for
#       now.
#     - get an explosion when the file system isn't defined - Windows?

########################################################################
# floppyOSListPopUp() -	Generates and pops-up a toplevel dialog with
#                       a directory listing of the given file, with the
#                       given filesystem.
########################################################################
proc floppyOSListPopUp {file filesystem fstype} {

    set winname [format ".osl_%s" [regsub -all "\\.|/|\\\\" $file "_"]]

    # first look for a window with the listing already in it

    if [winfo exists $winname] {
	raise $winname
    } else {
	toplevel $winname
	wm title $winname $filesystem
	
	button $winname.ok -text "OK" -command [list destroy $winname]

	iwidgets::Labeledframe $winname.listarea -labelpos nw -labeltext $filesystem
	set listarea [$winname.listarea childsite]

	iwidgets::scrolledtext $listarea.text -wrap none \
		-vscrollmode dynamic -hscrollmode dynamic \
		-textfont [iniGetAttribute "Font" "ProgramOutput"]

	pack $winname.listarea -side top -anchor n  -expand yes -fill x -fill y
	pack $listarea.text -side top -anchor n -expand yes -fill x -fill y
	pack $winname.ok -side bottom -anchor s
    
	$listarea.text insert end [floppyListOS $file $fstype]
    }
    focus $winname
}

########################################################################
# floppyFilesDialogCreate() -	Creates the dialog for selecting the image or
#                       the files that will be the floppy to load.
#                           ***  .ffd is the window identifier  ***
########################################################################
proc floppyFilesDialogCreate {} {
    global floppyCurrent
    global floppyType
    global floppyImage
    global floppyFiles
    global floppyFilesOS
    global floppyProtected
    global floppyMemoryUsed
    global OSListSimple
    global svdAutoLoad

    iwidgets::dialogshell .ffd -title "Select Floppy Image or Files" 

    .ffd add OK -text "OK" -command { 
	set floppyImage(temp) [[[.ffd childsite].image childsite].file get]
	set floppyFiles(temp) [[[.ffd childsite].files childsite].frame.list get 0 end]

	if { $floppyType(temp) == "image" } {
	    workingMessagePopUp "Checking floppy image..." .ffd
	    update
	    if { $floppyImage(temp) == "" || ! [floppyFilesDialogImageCheck $floppyImage(temp)] } {
		workingMessageRemove
		return
	    }
	} elseif { $floppyType(temp) == "files" } {
	    workingMessagePopUp "Checking OS file, and ability to write files to it..." .ffd
	    update
	    if { ! [floppyFilesDialogImageCheck $OSListFile($floppyFilesOS(temp))] ||
	           ( $floppyFiles(temp) != "" &&
	         ! [floppyFilesDialogOSAddCheck $OSListFile($floppyFilesOS(temp)) $OSListFS($floppyFilesOS(temp)) $floppyFiles(temp)]) } {
		     workingMessageRemove
		     return
	    }
	}
	# make sure old image is unloaded right
	if {$floppyLoaded($floppyCurrent) && $floppyEnabled($floppyCurrent)} {
	    svdMemoryUsageDecr $floppyMemoryUsed($floppyCurrent)
	}
	set floppyType($floppyCurrent) $floppyType(temp)
	set floppyImage($floppyCurrent) $floppyImage(temp)
	set floppyFiles($floppyCurrent) $floppyFiles(temp)
	set floppyFilesOS($floppyCurrent) $floppyFilesOS(temp)
	set floppyLoaded($floppyCurrent) 1
	set floppyMemoryUsed($floppyCurrent) $floppyMemoryUsed(temp)
	set floppyProtected($floppyCurrent) $floppyProtected(temp)
	floppyMemoryIndicator $floppyCurrent

	set floppyEnabled($floppyCurrent) 1		    

	set svdMemoryUsed [expr $svdMemoryUsed + $floppyMemoryUsed($floppyCurrent)]
	gaugeSetPercent [.svd childsite].gauge [expr $svdMemoryUsed * 100 / $svdMemoryBlocks]

	workingMessageRemove
	.ffd deactivate
	if { $floppyLoaded($floppyCurrent) } {
	    floppyGuiEnable $floppyCurrent
	    if { $svdAutoLoad } {
		downloadActivate
	    }
	} else {
	    floppyGuiDisable $floppyCurrent
	}

	# turn on both areas for update'ability

	floppyFilesDialogImageArea normal
	floppyFilesDialogFilesArea normal

	tipsDialogShow "Download"
	# turn on the "loaded" light here
    }
    .ffd add cancel -text "Cancel" -command {
	# turn on both areas for update'ability

	floppyFilesDialogImageArea normal
	floppyFilesDialogFilesArea normal

	.ffd deactivate
    }
    .ffd add help -text "Help" -command {
	tk_messageBox -default ok -icon info -title "Help" -type ok -message \
"In this dialog, you choose what to load onto the floppy.
You can choose one of two things: image or files."
}
#    .ffd configure -modality application

    set ffdwin [.ffd childsite]

    iwidgets::Labeledframe $ffdwin.image -labelpos nw -labeltext ""
    set ffdimage [$ffdwin.image childsite]

    radiobutton $ffdimage.image -text "Floppy image file" \
	    -variable floppyType(temp) -value "image" \
	    -command {
	         floppyFilesDialogImageArea normal
	         floppyFilesDialogFilesArea disabled
                 }

    iwidgets::entryfield $ffdimage.file \
	    -highlightthickness 0 \
	    -labelpos w \
	    -labeltext "Image file:" \
	    -textbackground "white" \
	    -width 30

    [$ffdimage.file component label] configure -justify left -underline 0

    message $ffdimage.message -justify left -relief sunken -width 300

    button $ffdimage.browse -text "Browse..." -command {
	set ffdimage [[.ffd childsite].image childsite]
	set newfile [floppyFilesBrowseImage .ffd "existing" ]
	if { $newfile != "" } {
	    $ffdimage.file delete 0 end
	    $ffdimage.file insert 0 $newfile
	    $ffdimage.file xview moveto 1
	    workingMessagePopUp "Checking image file..." .ffd
	    $ffdimage.message configure -text [floppyReport $newfile "description"]
	    workingMessageRemove
	}
    }

    pack $ffdimage.image -side top -anchor w
    pack $ffdimage.message -side bottom -anchor e -padx 3 -pady 3
    pack $ffdimage.browse -side right -padx 3 -pady 3
    pack $ffdimage.file -side right -padx 3 -pady 3

    iwidgets::Labeledframe $ffdwin.files -labelpos nw -labeltext ""
    set ffdfiles [$ffdwin.files childsite]

    radiobutton $ffdfiles.files -text "List of files" \
	    -variable floppyType(temp) -value "files" \
	    -command {
	         floppyFilesDialogImageArea disabled
	         floppyFilesDialogFilesArea normal
	         floppyFilesDialogCheckOS $OSListFS($floppyFilesOS(temp))
            }

    frame $ffdfiles.osframe

###########################################################
# I've been having a problem with tk_optionmenu...sometimes
# it won't select, and often the OK button won't work right
# after something has been selected.  I'm using the 
# iwidgets version now, because it appears to work BETTER
# although the same problem occasionally occurs.
# (this same work-around is in the rs232 settings box too.
###########################################################

    iwidgets::optionmenu $ffdfiles.osframe.osmenu -labeltext "Operating system:" -labelpos w \
	    -command { set floppyFilesOS(temp) [[[.ffd childsite].files childsite].osframe.osmenu get] 
	               floppyFilesDialogCheckOS $OSListFS($floppyFilesOS(temp))}

    pack $ffdfiles.osframe.osmenu

# Previously the OS list was loaded here, however, now it is loaded
# by floppyFilesDialogLoadOS, which does the line:
#    foreach i $OSListSimple { $ffdfiles.osframe.osmenu insert end $i }

###########################################################
# The old way with tk_optionMenu.
###########################################################
#    label $ffdfiles.osframe.label -text "Operating system:"
#    eval tk_optionMenu $ffdfiles.osframe.osmenu floppyFilesOS(temp) $OSListSimple
#
#    pack $ffdfiles.osframe.label -padx 3 -pady 3 -side left
#    pack $ffdfiles.osframe.osmenu -padx 3 -pady 3 -side left

####### here is the list box

    frame $ffdfiles.frame -borderwidth 10

    scrollbar $ffdfiles.frame.yscroll -command "$ffdfiles.frame.list yview"
    scrollbar $ffdfiles.frame.xscroll -orient horizontal \
	    -command "$ffdfiles.frame.list xview"
    listbox $ffdfiles.frame.list -width 40 -height 5 -setgrid 1 \
	    -selectmode multiple \
	    -yscroll "$ffdfiles.frame.yscroll set" \
            -xscroll "$ffdfiles.frame.xscroll set" \
	    -background white

    grid $ffdfiles.frame.list -row 0 -column 0 \
	    -rowspan 1 -columnspan 1 -sticky news
    grid $ffdfiles.frame.yscroll -row 0 -column 1 \
	    -rowspan 1 -columnspan 1 -sticky news
    grid $ffdfiles.frame.xscroll -row 1 -column 0 \
	    -rowspan 1 -columnspan 1 -sticky news
    grid rowconfig    $ffdfiles.frame 0 -weight 1 -minsize 0
    grid columnconfig $ffdfiles.frame 0 -weight 1 -minsize 0


    frame $ffdfiles.buttons

    button $ffdfiles.buttons.add -text "Add..." -command {
	set ffdfiles [[.ffd childsite].files childsite]
	set newfile [floppyFilesBrowseFiles .ffd ]
	if { $newfile != "" } {
	    $ffdfiles.frame.list insert end $newfile
	    $ffdfiles.frame.list xview moveto 1
	}
    }

    button $ffdfiles.buttons.del -text "Delete" -command {
	set ffdfiles [[.ffd childsite].files childsite]
	set dellist [$ffdfiles.frame.list curselection]
	foreach {i} [lsort -integer -decreasing $dellist] {
	    $ffdfiles.frame.list delete $i
	}
    }

    button $ffdfiles.buttons.list -text "List..." -command { 
	floppyOSListPopUp $OSListFile($floppyFilesOS(temp)) $floppyFilesOS(temp) $OSListFS($floppyFilesOS(temp))
    }

### pack it all in there

    pack $ffdfiles.osframe -side bottom -expand no -fill x
    pack $ffdfiles.files -side top -anchor w
    pack $ffdfiles.buttons -side right -fill y
    pack $ffdfiles.buttons.add -side top -padx 3 -pady 3
    pack $ffdfiles.buttons.del -side top -padx 3 -pady 3
    pack $ffdfiles.buttons.list -side bottom -padx 3 -pady 3
    pack $ffdfiles.frame -side right -expand no -fill y

    pack $ffdwin.image -side top -expand no -anchor n -fill x
    pack $ffdwin.files -side top -expand no -anchor n -fill x
}

########################################################################
# floppyFilesDialogLoadOS() -	Load the OS list into the floppy files
#                               dialog area.  Won't load it if there
#                               are no OS files available.
########################################################################
proc floppyFilesDialogLoadOS {} {
    global OSListSimple

    set ffdwin [.ffd childsite]
    set ffdfiles [$ffdwin.files childsite]

    # first clear the existing items (if any)

    $ffdfiles.osframe.osmenu delete 0 end

    # now load up the list

    if { $OSListSimple == "" } {
	$ffdfiles.osframe.osmenu insert end "(no file system images available)"
	# disable the ability to select files if no OS's are available
	floppyFilesDialogFilesArea disabled
	$ffdfiles.files configure -state disabled
    } else {
	foreach i $OSListSimple { $ffdfiles.osframe.osmenu insert end $i }
	$ffdfiles.files configure -state normal
    }
}

########################################################################
# floppyFilesDialogImageArea() -	enable/disable the image area
########################################################################
proc floppyFilesDialogImageArea {cmd} {
    set ffdimage [[.ffd childsite].image childsite]
    $ffdimage.file configure -state $cmd
    $ffdimage.browse configure -state $cmd
    if { $cmd == "disabled" } {
	$ffdimage.message configure -relief flat
    } else {
	$ffdimage.message configure -relief sunken
    }
}

########################################################################
# floppyFilesDialogAddFiles() -	enable/disable the "Add..." button
#                               for adding files.  This is normally done
#                               if the OS type isn't known by "fstool"
########################################################################
proc floppyFilesDialogAddFiles {cmd} {
    set ffdfiles [[.ffd childsite].files childsite]

    $ffdfiles.buttons.add configure -state $cmd
    $ffdfiles.buttons.del configure -state $cmd
    $ffdfiles.buttons.list configure -state $cmd
}

########################################################################
# floppyFilesDialogCheckOS() -	Checks the OS to see if it is supported
#                               by "fstool".  If it is, then the add
#                               button is enabled, otherwise it is
#                               disabled.
########################################################################
proc floppyFilesDialogCheckOS {ostype} {
    global supportedOSTypes

    foreach os $supportedOSTypes {
	if { $os == $ostype } {
	    floppyFilesDialogAddFiles normal
	    return
	}
    }
    floppyFilesDialogAddFiles disabled
}

########################################################################
# floppyFilesDialogFilesArea() -	enable/disable the files area
########################################################################
proc floppyFilesDialogFilesArea {cmd} {
    set ffdfiles [[.ffd childsite].files childsite]
# windows version doesn't support this
#    $ffdfiles.frame.list configure -state $cmd
    $ffdfiles.buttons.add configure -state $cmd
    $ffdfiles.buttons.del configure -state $cmd
    $ffdfiles.buttons.list configure -state $cmd
    $ffdfiles.osframe.osmenu configure -state $cmd
}


########################################################################
# floppyFilesDialogActivate() -	Displays the floppy files dialog.
########################################################################
proc floppyFilesDialogActivate {num} {
    global floppyLoaded
    global floppyType
    global floppyFiles
    global floppyImage
    global floppyEnabled
    global floppyProtected
    global floppyCurrent
    global floppyFilesOS
    global OSListSimple
    global OSListFS

    set floppyCurrent $num

    if { $floppyType($num) == "upload" } {
	tk_messageBox -default ok -icon info -title "Notice" -type ok -message \
"This floppy contains an uploaded image.  You must
eject it before loading another image into it."
	return
    }

    .ffd configure -title "Select image or files for Disk $num"
    if { $floppyLoaded($num) } {
	set floppyFiles(temp) $floppyFiles($num)
	set floppyFilesOS(temp) $floppyFilesOS($num)
	set floppyImage(temp) $floppyImage($num)
	set floppyType(temp) $floppyType($num)
    } else {
	set floppyFiles(temp) ""
	set floppyFilesOS(temp) [lindex $OSListSimple 0]
	set floppyImage(temp) ""
	set floppyType(temp) "image"
    }
    
    # there may not be any

    catch { [[.ffd childsite].files childsite].osframe.osmenu select $floppyFilesOS(temp) }

    set ffdfiles [[.ffd childsite].files childsite]
    $ffdfiles.frame.list delete 0 end
    foreach {i} $floppyFiles(temp) {
	$ffdfiles.frame.list insert 0 $i
    }
    $ffdfiles.frame.list xview moveto 1

    set ffdimage [[.ffd childsite].image childsite]
    $ffdimage.file delete 0 end
    $ffdimage.file insert 0 $floppyImage(temp)
    $ffdimage.file xview moveto 1
    if { $floppyImage(temp) != "" } {
	$ffdimage.message configure -text [floppyReport $floppyImage(temp) "description"]
    } else {
	$ffdimage.message configure -text ""
    }

    if { $floppyType(temp) == "files" } {
	floppyFilesDialogImageArea disabled
	floppyFilesDialogFilesArea normal
	floppyFilesDialogCheckOS $OSListFS($floppyFilesOS(temp))
    } else {
	floppyFilesDialogImageArea normal
	floppyFilesDialogFilesArea disabled
    }

    .ffd activate
}


########################################################################
# floppyFilesDialogOSAddCheck() -	check to make sure that all of
#                                 the given files can be added.
########################################################################
proc floppyFilesDialogOSAddCheck {osfile ostype filelist} {
    set output [floppyCheckOSAdd $osfile $ostype $filelist]

    if { $output != "" } {
	# have an error here
	tk_messageBox -default ok -icon error -title "ERROR"  \
	              -type ok -message $output
	return 0
    } else {
	return 1
    }
}

########################################################################
# floppyFilesDialogImageCheck() -	check the image file to see if
#                                       it can be loaded
########################################################################
proc floppyFilesDialogImageCheck {file} {
    global bad_format_message
    global density_warning
    global exceptions_warning
    global floppyMemoryUsed
    global floppyProtected
    global svdDDSupported

    if { ! [file readable $file] } {
	tk_messageBox -default ok -icon error -title "ERROR"  \
	              -type ok -message "Floppy image not found."
	return 0
    }
	
    set output [floppyReport $file "check"]
    set params [split $output ","]

    set format    [lindex $params 0]
    set protect   [lindex $params 1]
    set sides     [lindex $params 2]
    set tracks    [lindex $params 3]
    set sectors   [lindex $params 4]
    set sectorsex [lindex $params 5]
    set density   [lindex $params 6]
    set densityex [lindex $params 7]

    if { $format == "UNKNOWN FORMAT" } {
	tk_messageBox -default ok -icon error -title "ERROR"  \
	              -type ok -message $bad_format_message
	return 0
    } elseif { $density == 1 && !$svdDDSupported } {
	tk_messageBox -default ok -icon error -title "ERROR"  \
		      -type ok -message $density_warning
	return 0
    } elseif { ($sectorsex == 1 || $densityex == 1) && !$svdDDSupported } {
	tk_messageBox -default ok -icon error -title "ERROR"  \
		      -type ok -message $exceptions_warning
	return 0
    }

    set floppyMemoryUsed(temp) [svdMemoryUsageCalc $sides $tracks $sectors]
    set floppyProtected(temp) $protect

    return 1
}
